/*
 * @(#)ClassEvent.java  1.0  30. Januar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.oo.objectmodel;

import java.util.*;
/**
 * An event created by {@link OMClass} objects.
 *
 * @author  Werner Randelshofer
 * @version 1.0 30. Januar 2004  Created.
 */
public class OMClassEvent extends EventObject {
    private int index;
    
    public OMClassEvent(OMClass source) {
        super(source);
    }
    public OMClassEvent(OMClass source, int index) {
        super(source);
        this.index = index;
    }
    
    public OMClass getSimulatedClass() {
        return (OMClass) getSource();
    }

    public int getIndex() {
        return index;
    }
}
